﻿<%@ Page Title="" Language="vb" AutoEventWireup="false" MasterPageFile="~/Public.master" CodeBehind="registration.aspx.vb" Inherits="Web.registration" %>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <script type="text/javascript">
        function pageLoad() {
            var mpe = '<%= MPE_PanelErrores.ClientID %>';
            var background = $get(mpe + '_backgroundElement');
            if (background) $addHandler(background, 'click', hideModalPopupViaClient);
            return false;

        }
        function hideModalPopupViaClient() {
            var modalPopupBehavior = $find('<%= MPE_PanelErrores.ClientID %>');
            if (modalPopupBehavior) modalPopupBehavior.hide();
        }

    </script>
    <asp:UpdatePanel runat="server" ID="UpdatePanelRegistration" UpdateMode="Conditional">
        <ContentTemplate>

            <div class="reg-form">
                <fieldset>
                    <div class="row">
                        <asp:TextBox placeholder="First name" ID="FirstName" runat="server" CssClass="input" Text=""></asp:TextBox>
                    </div>
                    <div class="row">
                        <asp:TextBox placeholder="Last name" ID="LastName" runat="server" CssClass="input" Text=""></asp:TextBox>
                    </div>
                    <div class="row">
                        <asp:TextBox placeholder="Empresa / Particular" ID="Nombre" runat="server" CssClass="input" Text=""></asp:TextBox>
                    </div>
                    <div class="row">
                        <asp:TextBox placeholder="Mail" ID="Email" type="email" runat="server" CssClass="input" Text=""></asp:TextBox>
                    </div>
                    <div class="row">
                        <asp:TextBox placeholder="Country" ID="Country" runat="server" CssClass="input" Text=""></asp:TextBox>
                    </div>
                    <div class="row" style="display: none;">
                        <asp:DropDownList placeholder="Commercial" ID="Commercial" runat="server">
                            <asp:ListItem Text=" - Commercial that serves you -" Value=""></asp:ListItem>
                            <asp:ListItem Text="Anand Selvaraj" Value="Anand Selvaraj - aselvaraj@jbctools.com"></asp:ListItem>
                            <asp:ListItem Text="Billy Shen" Value="Billy Shen - shen@jbcsoldering.com"></asp:ListItem>
                            <asp:ListItem Text="Daniele Di Nunzio" Value="Daniele Di Nunzio - ddnunzio@jbctools.com"></asp:ListItem>
                            <asp:ListItem Text="David Barastegui" Value="David Barastegui - dbarastegui@jbctools.com"></asp:ListItem>
                            <asp:ListItem Text="Domenec Taberner" Value="Domenec Taberner - dtaberner@jbctools.com"></asp:ListItem>
                            <asp:ListItem Text="Emiliano Vega" Value="Emiliano Vega - evega@jbctools.com"></asp:ListItem>
                            <asp:ListItem Text="Enrique Moreno" Value="Enrique Moreno - emoreno@jbctools.com" Selected="True"></asp:ListItem>
                            <asp:ListItem Text="Feng" Value="Feng - lfeng@jbctools.com"></asp:ListItem>
                            <asp:ListItem Text="Frederic Derrien" Value="Frederic Derrien - fderrien@jbctools.com"></asp:ListItem>
                            <asp:ListItem Text="Hector Sunyer Subira" Value="Hector Sunyer Subira - hsunyer@jbcsoldering.cn"></asp:ListItem>
                            <asp:ListItem Text="Jose Luis Solorzano" Value="Jose Luis Solorzano - jlsolorzano@jbctools.com"></asp:ListItem>
                            <asp:ListItem Text="Karl Schmid" Value="Karl Schmid - kschmid@jbctools.com"></asp:ListItem>
                            <asp:ListItem Text="Martin Garcia" Value="Martin Garcia - m.garcia@jbctools.com"></asp:ListItem>
                            <asp:ListItem Text="Sean Torrens" Value="Sean Torrens - storrens@jbctools.com"></asp:ListItem>
                            <asp:ListItem Text="Tony Tang" Value="Tony Tang - ttang@jbcsoldering.cn"></asp:ListItem>
                            <asp:ListItem Text="Tyler Wang" Value="Tyler Wang - ywang@jbcsoldering.cn"></asp:ListItem>
                        </asp:DropDownList>
                    </div>
                    <div class="form-section">
                        <div class="row">
                            <asp:TextBox placeholder="Contraseña" ID="Password" runat="server" CssClass="input" Text="" TextMode="Password"></asp:TextBox>
                        </div>
                        <div class="row">
                            <asp:TextBox placeholder="Repetir contraseña" ID="RepeatPassword" runat="server" CssClass="input" Text="" TextMode="Password"></asp:TextBox>
                        </div>
                    </div>
                    <div class="form-section">
                        <div class="row" id="divCodServidor" runat="server">
                            <asp:TextBox placeholder="Código Servidor" ID="CodigoServidor" runat="server" CssClass="input" Text=""></asp:TextBox>
                        </div>
                        <div class="row">
                            <asp:CheckBox ID="chkLegal" runat="server" CssClass="checkbox" /><asp:LinkButton ID="btnLegal" Style="color: #3d3d3d; text-decoration: underline;" runat="server" OnClick="btnLegal_Click"></asp:LinkButton>
                        </div>
                    </div>
                    <div class="row">
                        <asp:LinkButton ID="btn_Aceptar" CssClass="btn" runat="server" OnClick="btn_Aceptar_Click"><%= Translator.Translate("ADMIN_BTN_DELETE_OK")%></asp:LinkButton>
                        <asp:LinkButton ID="btn_cancel" CssClass="btn" runat="server" Style="float: right;" OnClick="btn_cancel_Click"><%= Translator.Translate("ADMIN_BTN_CANCEL")%></asp:LinkButton>
                    </div>
                </fieldset>

                <!--Panel de errores del formulario de registro -->
                <asp:Panel ID="PanelErrores" runat="server" Style="display: none" CssClass="error-message">
                    <div class="holder">
                        <asp:Literal ID="infoerrores" runat="server"></asp:Literal>
                        <a id="btnCancelar_PanelErrores" href="#" runat="server" class="btn">Ok</a>
                    </div>
                </asp:Panel>

                <!-- controles ajax-->
                <ajaxToolkit:ModalPopupExtender ID="MPE_PanelErrores" runat="server" TargetControlID="hdnPanelErrores" PopupControlID="PanelErrores" BackgroundCssClass="" CancelControlID="btnCancelar_PanelErrores" DropShadow="false" PopupDragHandleControlID="" />

                <!-- controles ocultos-->
                <asp:HiddenField ID="hdnPanelErrores" runat="server" />

                <!--Panel de condiciones legales -->
                <asp:Panel ID="PanelLegal" runat="server" Style="display: none;" CssClass="error-message ">
                    <div class="holder">
                        <div class="legal">
                            <div class="jcf-scrollable" style="height: 260px; overflow: hidden; font-size: 16px !important; text-align: left !important; padding: 5px; margin: 0 auto !important;">
                                <asp:Literal ID="litLegal" runat="server"></asp:Literal>
                            </div>
                        </div>
                        <br />
                        <a id="btnCancelar_PanelLegal" href="#" runat="server" class="btn">Ok</a>
                    </div>
                </asp:Panel>

                <!-- controles ajax-->
                <ajaxToolkit:ModalPopupExtender ID="MPE_PanelLEGAL" runat="server" TargetControlID="hdnPanelLegal" PopupControlID="PanelLegal" BackgroundCssClass="" CancelControlID="btnCancelar_PanelLegal" DropShadow="false" PopupDragHandleControlID="" />
                <!-- controles ocultos-->
                <asp:HiddenField ID="hdnPanelLegal" runat="server" />
            </div>

        </ContentTemplate>
        <Triggers>
            <asp:AsyncPostBackTrigger ControlID="btn_Aceptar" EventName="Click" />
        </Triggers>
    </asp:UpdatePanel>
    <ajaxToolkit:UpdatePanelAnimationExtender ID="UpdatePanelAnimationExtenderRegistration" TargetControlID="UpdatePanelRegistration" BehaviorID="animation" runat="server">
        <Animations>    
            <OnUpdated>
                <Sequence>
                    <FadeIn AnimationTarget="PanelErrores" Duration="0.15" minimumOpacity=".3"  />
                    <EnableAction AnimationTarget="btnCancelar_PanelErrores" Enabled="true" />
                    <ScriptAction Script="initRefreshFunctions();" />
                </Sequence>
            </OnUpdated>
        </Animations>
    </ajaxToolkit:UpdatePanelAnimationExtender>

    <asp:UpdateProgress ID="UpdateProgressRegistration" runat="server" AssociatedUpdatePanelID="UpdatePanelRegistration" DisplayAfter="100">
        <ProgressTemplate>
            <asp:Image ID="img_ajax_loading_Recorder" runat="server" ImageUrl="~/images/ajax-loading.gif" CssClass="ajax_loading_centered" />
        </ProgressTemplate>
    </asp:UpdateProgress>

</asp:Content>
